import { getLang } from 'utils/language/getLang';
import { SupportedLanguage } from 'utils/language/types';

import { I18nLocale } from 'shared/consts/I18nLocale';

const LOCALES: Record<SupportedLanguage, I18nLocale> = {
    en: I18nLocale['en-US'],
    ru: I18nLocale['ru-RU'],
    cs: I18nLocale['cs-CZ'],
};

export const getI18nLocale = (): I18nLocale => {
    const lang = getLang();

    return LOCALES.hasOwnProperty(lang) ? LOCALES[lang] : LOCALES.en;
};
