import { SupportedLanguage } from 'utils/language/types';

const LANGS: Record<SupportedLanguage, boolean> = {
    en: true,
    cs: true,
    ru: true,
};

export const getLang = (): SupportedLanguage => {
    const lang = process.env.LANG;

    return lang && LANGS.hasOwnProperty(lang) ? (lang as SupportedLanguage) : 'en';
};
