import { SupportedLanguage } from 'utils/language/types';

import { isVlootkit } from 'shared/helpers/isVlootkit/isVlootkit';

const EXP_PERIOD = 10;

export const setLang = (lang: SupportedLanguage) => {
    const expDate = new Date();
    expDate.setFullYear(expDate.getFullYear() + EXP_PERIOD);

    const name = isVlootkit() ? 'vlang' : 'dm_lang';

    document.cookie = `${name}=${encodeURIComponent(lang)}; expires=${expDate.toUTCString()}; path=/`;
};
