import { getTLD } from 'utils/getTLD';

import { getCookie } from 'shared/helpers/getCookie/getCookie';
import { isVlootkit } from 'shared/helpers/isVlootkit/isVlootkit';

export function logOut() {
    const tld = getTLD();

    if (isVlootkit()) {
        fetch('/auth/api/csrf', { method: 'GET', credentials: 'include' })
            .then((response) => response.json())
            .then((payload) => {
                return fetch('/auth/api/logout', {
                    method: 'POST',
                    credentials: 'include',
                    headers: {
                        'x-csrf-token': payload.data.csrf,
                    },
                });
            })
            .then((response) => {
                if (response.ok) {
                    location.href = '/auth';
                }
            });
    } else {
        location.href = `https://passport.yandex.${tld}/?mode=logout&yu=${getCookie(
            'yandexuid',
        )}&retpath=${encodeURIComponent(
            `https://passport.yandex.${tld}/auth/list?retpath=${location.origin}&noreturn=1`,
        )}`;
    }
}
