import { Areas } from 'components/ui/Buttons/AreasButton/AreasWidget';
import { IArea } from 'components/Zones/types';

interface ICreateAreaProps {
    area: IArea;
    inner?: number[][];
    outer: number[][];
    properties?: any;
    options?: any;
    createdAreaCallback?: (area: IArea, polygon: any) => void;
    type: Areas;
}

const DEFAULT_POLY_OPTIONS = {
    fillColor: 'rgba(255, 255, 255, 0.8)',
    interactivityModel: 'default#transparent',
    strokeWidth: 0,
    visible: true,
};

declare let ymaps: any;

export default function createArea({
    area,
    outer,
    inner,
    properties,
    options,
    createdAreaCallback,
    type,
}: ICreateAreaProps): ymaps.Polygon {
    let areasOptions = options ? Object.assign(DEFAULT_POLY_OPTIONS, options) : DEFAULT_POLY_OPTIONS;
    let polygon = new ymaps.Polygon(
        [outer || [], inner || []],
        properties ? { type, ...properties } : { type },
        areasOptions,
    );

    if (createdAreaCallback) {
        createdAreaCallback(area, polygon);
    }

    return polygon;
}
