/*eslint-disable @typescript-eslint/no-magic-numbers*/
import createArea from 'utils/map/area/createArea';

import { Areas } from 'components/ui/Buttons/AreasButton/AreasWidget';
import { IArea } from 'components/Zones/types';

interface ICreateGlobalAreasProps {
    inner?: any;
    collection: ymaps.GeoObjectCollection;
    propertiesFunc?: (area: IArea) => any;
    optionsFunc?: (area: IArea) => any;
    createdAreaCallback?: (area: IArea, polygon: any) => any;
}

const GlobalAreaRight = [
    [-10, 90],
    [170, 90],
    [170, -90],
    [-10, -90],
    [-10, 90],
];
const GlobalAreaLeft = [
    [170, 90],
    [-10.000001, 90],
    [-10.000001, -90],
    [170, -90],
    [170, 90],
];

export default function createGlobalAreas({
    inner,
    collection,
    propertiesFunc,
    optionsFunc,
    createdAreaCallback,
}: ICreateGlobalAreasProps) {
    inner &&
        collection?.add(
            createArea({
                area: inner,
                outer: GlobalAreaRight,
                inner: inner?.area_coords,
                type: Areas.FORBIDDEN_TO_RIDE,
                properties: propertiesFunc ? propertiesFunc(inner) : null,
                options: optionsFunc ? optionsFunc(inner) : null,
                createdAreaCallback,
            }),
        );
    inner &&
        collection?.add(
            createArea({
                outer: GlobalAreaLeft,
                area: inner,
                type: Areas.FORBIDDEN_TO_RIDE,
                properties: propertiesFunc ? propertiesFunc(inner) : null,
                options: optionsFunc ? optionsFunc(inner) : null,
                createdAreaCallback,
            }),
        );
}
