import createArea from 'utils/map/area/createArea';

import { Areas } from 'components/ui/Buttons/AreasButton/AreasWidget';
import { IArea } from 'components/Zones/types';

interface ICreateOtherAreasProps {
    areas?: any[];
    collection: ymaps.GeoObjectCollection;
    extractArea: any;
    propertiesFunc?: (area: IArea) => any;
    optionsFunc?: (area: IArea) => any;
    createdAreaCallback?: (area: IArea, polygon: any) => any;
}

const OTHER_AREAS_OPTIONS = {
    fillColor: 'rgba(255, 58, 58, 0.15)',
    strokeWidth: 2,
    strokeColor: 'rgba(255, 58, 58, 0.5)',
    strokeStyle: '2 4',
    visible: true,
};

export default function createOtherAreas({
    areas,
    collection,
    extractArea,
    propertiesFunc,
    optionsFunc,
    createdAreaCallback,
}: ICreateOtherAreasProps) {
    areas?.forEach((area) => {
        if (area.area_id !== extractArea?.area_id) {
            collection?.add(
                createArea({
                    area,
                    outer: area.area_coords,
                    properties: propertiesFunc ? propertiesFunc(area) : null,
                    options: optionsFunc ? Object.assign(OTHER_AREAS_OPTIONS, optionsFunc(area)) : OTHER_AREAS_OPTIONS,
                    createdAreaCallback,
                    type: Areas.FORBIDDEN_TO_PARK,
                }),
            );
        }
    });
}
