import { IShowItemsFilter } from 'utils/map/area/types';

interface IShowAreaProps extends IShowItemsFilter {
    collection: ymaps.GeoObjectCollection;
}

export default function showArea({ collection, ...filters }: IShowAreaProps): void {
    collection?.each((element) => {
        let currentType = element.properties.get('type');
        let currentTypeValue = filters[currentType];

        element.options.set('visible', currentTypeValue);
    });
}
