import isWarning from 'utils/car/isWarning';
import createClusterIcon from 'utils/map/layout/createClusterIcon';

import { badgeSize, clusterSize } from 'components/Map/controls/Cluster';
import { ZOOM_DURATION } from 'components/Map/controls/constants';

declare let ymaps: any;

const CLUSTER_SHAPE_SIZE = 50;
const HALF_CLUSTER_SHAPE_SIZE = 25;
const MIN_CLUSTER_SIZE = 4;
const CLUSTER_SHAPE_TYPE = 'Rectangle';
const MAX_CLUSTER_LABEL_COUNT = 99;
const CLUSTER_GRID_SIZE = 128;
const ZOOM_STEP = 2;

export default function createCluster() {
    let clusterer = new ymaps.Clusterer({
        gridSize: CLUSTER_GRID_SIZE,
        minClusterSize: MIN_CLUSTER_SIZE,
        size: [CLUSTER_SHAPE_SIZE, CLUSTER_SHAPE_SIZE],
        offset: [-HALF_CLUSTER_SHAPE_SIZE, -HALF_CLUSTER_SHAPE_SIZE],
        clusterIconLayout: createClusterIcon(),
        clusterDisableClickZoom: true,
        clusterHideIconOnBalloonOpen: false,
        geoObjectHideIconOnBalloonOpen: false,
        clusterOpenBalloonOnClick: false,
        clusterIconShape: {
            type: CLUSTER_SHAPE_TYPE,
            coordinates: [
                [0, 0],
                [CLUSTER_SHAPE_SIZE, CLUSTER_SHAPE_SIZE],
            ],
        },
    });
    clusterer.createCluster = function (this: any, center, geoObjects) {
        let clusterPlacemark = ymaps.Clusterer.prototype.createCluster.call(this, center, geoObjects);
        let warningCars = geoObjects.filter((car) => isWarning(car.properties.get('car')?.status))?.length;

        clusterPlacemark.properties.set({
            customOptions: {
                badge: warningCars,
                mainCount: geoObjects.length,
                badgeSize: warningCars > MAX_CLUSTER_LABEL_COUNT ? badgeSize.large : badgeSize.common,
                clusterSize: geoObjects.length > MAX_CLUSTER_LABEL_COUNT ? clusterSize.large : clusterSize.common,
            },
        });

        return clusterPlacemark;
    };

    clusterer.events.add('click', (e) => {
        let map = clusterer.getMap();
        let curZoom = map.getZoom();

        let center = e?.get('target')?.geometry?.getCoordinates();

        map.setCenter(center, curZoom + ZOOM_STEP, {
            checkZoomRange: true,
            duration: ZOOM_DURATION,
        });
    });

    return clusterer;
}
