import * as React from 'react';
import ReactDOMServer from 'react-dom/server';

import { BEACON_SEARCH_STATE } from 'components/Cars/CarCard/CarCardOverview/CarMainWidget/BeaconSwitchMode/types';
import { BeaconEnabledPinLayout, BeaconPinLayout } from 'components/Map/controls/BeaconPinLayout';
import { IBeacon } from 'components/Map/controls/BeaconPinLayout/types';

declare let ymaps: any;

export default function createBeaconPin(beaconInfo: IBeacon) {
    if (beaconInfo.beacon_search_state == BEACON_SEARCH_STATE.ENABLED) {
        return ymaps.templateLayoutFactory.createClass(ReactDOMServer.renderToString(<BeaconEnabledPinLayout />));
    }

    return ymaps.templateLayoutFactory.createClass(ReactDOMServer.renderToString(<BeaconPinLayout />));
}
