import React from 'react';
import ReactDOMServer from 'react-dom/server';

import { GPSPinIconLayout } from 'components/Map/controls/GPSPinIconLayout';

interface ICreateCarPinProps {
    car: any;
    isWarning: boolean;
}
declare let ymaps: any;

export default function createCarPin({ car, isWarning }: ICreateCarPinProps) {
    return ymaps.templateLayoutFactory.createClass(
        ReactDOMServer.renderToString(
            <GPSPinIconLayout
                car={car}
                isWarning={isWarning}
            />,
        ),
    );
}
