import React from 'react';
import ReactDOMServer from 'react-dom/server';

import { CarMapTooltip } from 'components/Cars/CarMapTooltip';

declare let ymaps: any;

const TOOLTIP_BOUND = {
    width: 310,
    height: 310,
};

export default function createHint({ car, address, addressLoading }) {
    return ymaps.templateLayoutFactory.createClass(
        ReactDOMServer.renderToString(
            <CarMapTooltip
                carInfo={car}
                addressLoading={addressLoading}
                address={address}
            />,
        ),
        {
            getShape: function () {
                return new ymaps.shape.Rectangle(
                    new ymaps.geometry.pixel.Rectangle([
                        [0, 0],
                        [TOOLTIP_BOUND.width, TOOLTIP_BOUND.height],
                    ]),
                );
            },
        },
    );
}
