enum MapCGIOptions {
    ZOOM = 'zoom',
    LON = 'lon',
    LAT = 'lat',
}

type IMapOptions = Record<MapCGIOptions, string | null>;

export default function getCgiMapOptions(props): IMapOptions {
    let urlSearchParams = new URLSearchParams(props.location.search);
    const wrap = (type: MapCGIOptions) => urlSearchParams.get(type);

    return {
        [MapCGIOptions.ZOOM]: wrap(MapCGIOptions.ZOOM),
        [MapCGIOptions.LON]: wrap(MapCGIOptions.LON),
        [MapCGIOptions.LAT]: wrap(MapCGIOptions.LAT),
    };
}
