import initMapApi from 'utils/map/map/initMapApi';

import { layerVectorCustomization } from 'components/Map/layerVectorCustomization';

const ZOOM = {
    DEFAULT: 12,
    MIN: 2,
    MAX: 19,
};

export interface IInitMapProps {
    id?: string;
    zoom?: number;
    center?: [number, number];
    callback?: Function;
    hideZoomControls?: boolean;
    hideBoundControls?: boolean;
}

export default function initMap(props: IInitMapProps) {
    let { zoom = ZOOM.DEFAULT, id = '', callback, center = [0, 0] } = props;
    let mapScript = initMapApi();

    let vectorConfig = {
        vector: true,
        layerVectorRevealThreshold: 0,
        layerVectorCustomization,
    };

    let createMap = () => {
        // @ts-ignore
        window.ymaps.ready(() => {
            let map = new ymaps.Map(
                id,
                {
                    center,
                    zoom,
                    controls: [],
                },
                {
                    minZoom: ZOOM.MIN,
                    maxZoom: ZOOM.MAX,
                    suppressMapOpenBlock: true,
                    copyrightLogoVisible: false,
                    copyrightProvidersVisible: false,
                    copyrightUaVisible: false,
                    ...vectorConfig,
                },
            );
            map.layers.events.add('vectorerror', () => {
                map.destroy();
                console.error('Error while trying to display vector backing');
            });
            callback?.(map);
        });
    };

    // @ts-ignore
    if (window.ymaps) {
        createMap();
    } else {
        mapScript.addEventListener('load', () => {
            createMap();
        });
    }
}
