import { getTLD } from 'utils/getTLD';
import { getLang } from 'utils/language/getLang';

import { isVlootkit } from 'shared/helpers/isVlootkit/isVlootkit';

const ALLOWED_TLD = {
    ru: true,
    com: true,
};

export default function initMapApi() {
    let tld = getTLD();

    if (!ALLOWED_TLD[tld]) {
        tld = 'com';
    }

    let head = document.getElementsByTagName('head')[0];
    let scripts: any = head.getElementsByTagName('script');
    let mapScript: any = null;
    let isMapExist = [...scripts].some((script) => {
        let src = script.getAttribute('src');
        if (src && src.includes(`https://api-maps.yandex.${tld}/2.1`)) {
            mapScript = script;

            return true;
        }

        return false;
    });

    const mapCode = getLang() === 'ru' ? 'ru_RU' : 'en_US';
    const apikey = isVlootkit() ? 'apikey=8f458605-b081-494a-aead-05a1f859adf9&' : '';

    if (!isMapExist) {
        mapScript = document.createElement('script');
        mapScript.src = `https://api-maps.yandex.${tld}/2.1/?${apikey}load=package.full,vectorEngine.preload&lang=${mapCode}&coordorder=longlat`;
        mapScript.crossorigin = 'anonymous';
        document.getElementsByTagName('head')[0].appendChild(mapScript);
    }

    return mapScript;
}
