import isWarning from 'utils/car/isWarning';
import { ICarInfo } from 'utils/car/types';
import createBeaconPin from 'utils/map/layout/createBeaconPin';
import createCarPin from 'utils/map/layout/createCarPin';
import createHint from 'utils/map/layout/createHint';
import getBeaconCoordinates from 'utils/map/placemark/getBeaconCoordinates';
import getGPSCoordinates from 'utils/map/placemark/getGPSCoordinates';

import { getAddress } from 'entities/Geo/helpers/getAddress/getAddress';

import { IBeacon } from 'components/Map/controls/BeaconPinLayout/types';
import { IMapProps } from 'components/Map/types';

declare let ymaps: any;

const IMAGE_SIZE = 24;
const IMAGE_OFFSET = 8;

export default function createPlacemark({
    car,
    beacon,
    props,
}: {
    car?: ICarInfo;
    props: IMapProps;
    beacon?: IBeacon;
}) {
    let iconContentLayout = car
        ? createCarPin({
              car,
              isWarning: isWarning(car?.status),
          })
        : beacon
        ? createBeaconPin(beacon)
        : null;

    let coordinates = car ? getGPSCoordinates(car) : beacon ? getBeaconCoordinates(beacon) : null;

    let placemark = new ymaps.Placemark(
        coordinates,
        { car, address: null },
        {
            hideIconOnBalloonOpen: false,
            iconLayout: 'default#imageWithContent',
            cursor: props.withoutTooltips ? null : 'pointer',
            iconImageHref: '',
            iconImageSize: [IMAGE_SIZE, IMAGE_SIZE],
            iconImageOffset: [IMAGE_OFFSET, -IMAGE_OFFSET],
            hintLayout: !props.withoutTooltips
                ? createHint({
                      car,
                      address: null,
                      addressLoading: true,
                  })
                : null,
            iconContentLayout,
        },
    );

    placemark.events.add('hintopen', () => {
        getAddress([car?.location?.lon || 0, car?.location?.lat || 0]).then((address) => {
            placemark.options.set(
                'hintLayout',
                createHint({
                    car,
                    address,
                    addressLoading: false,
                }),
            );
        });
    });

    placemark.events.add(['click'], (event) => {
        let car = event.get('target').properties.get('car');

        if (car?.id && !props.withoutTooltips) {
            props.history.push(`cars/${car?.id}`);
        }
    });

    return placemark;
}
