const ZOOM = 14;
const DURATION = 600;

export function onTimelineClick(e) {
    let { originId, target } = e.originalEvent;

    target?.each((element) => {
        let id = element.properties.get('id');
        let isCurrent = originId && id == originId;
        if (isCurrent) {
            let map = element.getMap();

            let center = element?.geometry?.getCoordinates();

            map.setCenter(center, ZOOM, {
                checkZoomRange: true,
                duration: DURATION,
            });
        }
    });
}
