import createTracePin from 'utils/map/layout/createTracePin';
import generateId from 'utils/map/trace/generateId';
import { IconTraceType, ICreatePinProps } from 'utils/map/trace/types';

declare let ymaps: any;
const IMAGE_DEFAULT_SIZE = 16;
const HALF = 2;
const SPEEDING_X = 78;
const SPEEDING_Y = 44;
const SPEEDING_DELTA = 10;

const getOffsets = (type) => {
    if (type === IconTraceType.SPEEDING) {
        return [-SPEEDING_X / HALF, -SPEEDING_Y / HALF - SPEEDING_DELTA];
    } else {
        return [-IMAGE_DEFAULT_SIZE / HALF, -IMAGE_DEFAULT_SIZE / HALF];
    }
};

const getSize = (type) => {
    if (type === IconTraceType.SPEEDING) {
        return [SPEEDING_X, SPEEDING_Y];
    } else {
        return [IMAGE_DEFAULT_SIZE, IMAGE_DEFAULT_SIZE];
    }
};

export default function createPin(props: ICreatePinProps) {
    let { center, type, id, visible = true, options } = props;

    return new ymaps.Placemark(
        center,
        {
            id: id || generateId({ center, type }),
            type,
        },
        {
            hovered: false,
            visible,
            hideIconOnBalloonOpen: false,
            iconLayout: 'default#imageWithContent',
            iconImageHref: '',
            iconImageSize: getSize(type),
            iconImageOffset: getOffsets(type),
            iconContentLayout: createTracePin({ type, options }),
        },
    );
}
