import { TRACE_STROKE } from 'utils/map/trace/constants';
import getTrack from 'utils/map/trace/getTrack';
import normalizeCoordinates from 'utils/map/trace/normalizeCoordinates';
import { ITraceItem } from 'utils/map/trace/types';

declare let ymaps: any;
export default function createTrack(traces: ITraceItem[]) {
    return new ymaps.Polyline(
        normalizeCoordinates(getTrack(traces)),
        {},
        {
            strokeColor: '#000000',
            strokeWidth: TRACE_STROKE,
        },
    );
}

const createTrack2 = (geometry: number[][], isSpeeding) => {
    return new ymaps.Polyline(
        geometry,
        {},
        {
            strokeColor: isSpeeding ? '#FF3A3A' : '#000000',
            strokeWidth: TRACE_STROKE,
        },
    );
};

export { createTrack2 };
