import { TRACE_STROKE } from 'utils/map/trace/constants';
import normalizeCoordinates from 'utils/map/trace/normalizeCoordinates';
import { ICreatePinProps } from 'utils/map/trace/types';

declare let ymaps: any;

interface IViolationTrackProps {
    track: number[];
    fakePlacemark: ICreatePinProps;
}

export default function createViolationTrack({ track, fakePlacemark }: IViolationTrackProps) {
    return new ymaps.Polyline(
        normalizeCoordinates(track),
        { fakePlacemark },
        {
            strokeColor: '#FF3A3A',
            strokeWidth: TRACE_STROKE + 1,
        },
    );
}
