import { IconTraceType } from 'utils/map/trace/types';

const simplePoint: IconTraceType[] = [IconTraceType.CURRENT, IconTraceType.START, IconTraceType.FINISH];

export default function generateId(data: { center: number[]; type: IconTraceType }) {
    let { center, type } = data;
    if (type && simplePoint.includes(type)) {
        return type;
    }

    return `${type}_${center.join('_')}`;
}
