import createTracePin from 'utils/map/layout/createTracePin';
import generateId from 'utils/map/trace/generateId';
import { IconTraceType } from 'utils/map/trace/types';

export function onMouseEnterLeave(hover, e) {
    let eventType = e.get('type');
    let parent = e.get('target').getParent();

    if (eventType === 'mouseleave') {
        parent.events.fire('hover', { originId: null });
        hover(null);
    } else {
        let { properties } = e.get('target') || {};

        let currentObjType = properties.get('type');
        let isFakePlacemark = properties.get('fakePlacemark');

        if (isFakePlacemark) {
            let originId = generateId(isFakePlacemark);
            parent.events.fire('hover', { originId });
            hover(originId);
        } else if (currentObjType) {
            if (currentObjType === IconTraceType.EVENT || currentObjType === IconTraceType.AGGRESSION) {
                currentObjType = generateId({
                    type: currentObjType,
                    center: e.get('target').geometry.getCoordinates(),
                });
            }
            parent.events.fire('hover', { originId: currentObjType });
            hover(currentObjType);
        }
    }
}

export function onHover(e) {
    let { originId, target } = e.originalEvent;

    target?.each((element) => {
        let id = element.properties.get('id');
        let type = element.properties.get('type');
        let isCurrent = originId && id == originId;

        switch (type) {
            case IconTraceType.SPEEDING:
                onHoverOVERSPEED(element, isCurrent);
                break;
            case IconTraceType.EVENT:
            case IconTraceType.START:
            case IconTraceType.AGGRESSION:
            case IconTraceType.FINISH:
            case IconTraceType.CURRENT:
                onHoverEVENT(element, isCurrent);
                break;
            default:
                break;
        }
    });
}

function onHoverOVERSPEED(element, isCurrent) {
    element.options.set('visible', isCurrent);
}

function onHoverEVENT(element, isCurrent) {
    if (isCurrent) {
        element.options.set(
            'iconContentLayout',
            createTracePin({
                type: element.properties.get('type'),
                hovered: true,
            }),
        );
    } else {
        element.options.set('iconContentLayout', createTracePin({ type: element.properties.get('type') }));
    }
}
