import { ITimelineItem } from 'components/GlobalSidebar/ModalSessionView/TrackTimeline';
import { IBaseMapProps, IViolationItem } from 'components/Map/types';

export enum IconTraceType {
    START = 'Start',
    FINISH = 'Finish',
    CURRENT = 'Current',
    AGGRESSION = 'Aggression',
    ACCELERATION = 'Acceleration',
    BRAKING = 'Braking',
    STRAIGHT_LATERAL_ACCELERATION = 'Straight lateral acceleration',
    TURNING_LATERAL_ACCELERATION = 'Turning lateral acceleration',
    EVENT = 'Event',
    SPEEDING = 'Speeding',
    CAMERA = 'Camera',
}

interface IPinIconTraceSpeedingOptions {
    value: string;
    is_hard?: boolean;
}

interface IPinCommonProps {
    type: IconTraceType;
    options?: IPinIconTraceSpeedingOptions;
}

export interface IPinIconTraceLayout extends IPinCommonProps {
    hovered?: boolean;
}

export interface ITraceItem {
    car: string;
    finish_timestamp: number;
    ride: string;
    session: string;
    start_timestamp: number;
    status: string;
    summary: {
        length: number;
        violation_length: number;
        violation_parts: number;
    };
    track: number[];
    user: string;
    violations: IViolationItem[];
}

export interface ICreatePinProps extends IPinCommonProps {
    center: number[];
    id?: string;
    visible?: boolean;
}

export interface ITrackMapProps extends IBaseMapProps {
    timeline: ITimelineItem[];
    session: any | null;
    hovered: string | null;
    clicked: string | null;
    hover: any;
}

export interface IZoneEditorProps extends IBaseMapProps {
    isCreateZoneMode: boolean;
    onFinishCreatingCoordinates: (areasCoordinates: [number, number][][]) => void;
    onZoneClick: (zoneName: string) => void;
}
