import getFinish from 'utils/sessions/getFinish';
import getStart from 'utils/sessions/getStart';
import { ISession } from 'utils/sessions/types';

import { RideSchema } from 'entities/Ride/types/RideSchema';

export default function getCoordinatesDiff(session: ISession | RideSchema): boolean {
    let start = getStart(session);
    let finish = getFinish(session);

    let latitudeDiff = start?.latitude && finish?.latitude ? finish?.latitude - start?.latitude !== 0 : false;

    let longitudeDiff = start?.longitude && finish?.longitude ? finish?.longitude - start?.longitude !== 0 : false;

    return latitudeDiff || longitudeDiff;
}
