import { ISession, ISessionSegmentDiffItem } from 'utils/sessions/types';

import { RideSchema } from 'entities/Ride/types/RideSchema';

export default function getCurrent(
    session: ISession | RideSchema | null,
): Partial<ISessionSegmentDiffItem> | undefined {
    if (!session) {
        return undefined;
    }

    let segment = session.segment;
    let track = session.track;
    let current: Partial<ISessionSegmentDiffItem> | undefined;
    let currentDiff: Partial<ISessionSegmentDiffItem> | undefined = segment.diff?.current;

    if (currentDiff) {
        if (currentDiff) {
            currentDiff.timestamp = segment.finish;
            current = currentDiff;
        } else {
            current = {
                timestamp: segment.finish,
            };
        }
    }

    if (track?.track_current) {
        if (current) {
            current.latitude = track.track_current[1];
            current.longitude = track.track_current[0];
        } else {
            current = {
                latitude: track.track_current[1],
                longitude: track.track_current[0],
            };
        }
    }

    return current;
}
