import { ONE_SECOND } from 'constants/constants';

import { durationBetween } from 'utils/sessions/durationBetween';
import getFinish from 'utils/sessions/getFinish';
import getStart from 'utils/sessions/getStart';
import { ISession } from 'utils/sessions/types';

import { RideSchema } from 'entities/Ride/types/RideSchema';

export default function getDuration(session: ISession | RideSchema) {
    let start = getStart(session)?.timestamp ?? null;
    let finish = getFinish(session)?.timestamp ?? null;
    if (start && !finish) {
        finish = Date.now() / ONE_SECOND;
    }

    return start && finish ? durationBetween([finish, start]) : null;
}
