import { ISession, ISessionSegmentDiffItem } from 'utils/sessions/types';

import { RideSchema } from 'entities/Ride/types/RideSchema';

export default function getFinish(session: ISession | RideSchema | null): Partial<ISessionSegmentDiffItem> | undefined {
    if (!session) {
        return undefined;
    }

    let segment = session.segment;

    if (segment.diff?.current) {
        return undefined;
    }

    let track = session.track;
    let finish: Partial<ISessionSegmentDiffItem> | undefined;
    let finishDiff: Partial<ISessionSegmentDiffItem> | undefined = segment.diff?.finish;

    if (segment.finish) {
        if (finishDiff) {
            finishDiff.timestamp = segment.finish;
            finish = finishDiff;
        } else {
            finish = {
                timestamp: segment.finish,
            };
        }
    }

    if (track?.track_finish) {
        if (finish) {
            finish.latitude = track.track_finish[1];
            finish.longitude = track.track_finish[0];
        } else {
            finish = {
                latitude: track.track_finish[1],
                longitude: track.track_finish[0],
            };
        }
    }

    return finish;
}
