import { ISession, ISessionSegmentDiffItem } from 'utils/sessions/types';

import { RideSchema } from 'entities/Ride/types/RideSchema';

export default function getStart(session: ISession | RideSchema | null): Partial<ISessionSegmentDiffItem> | undefined {
    if (!session) {
        return undefined;
    }

    let start: Partial<ISessionSegmentDiffItem> | undefined;
    let segment = session.segment;
    let track = session.track;
    let startDiff: Partial<ISessionSegmentDiffItem> | undefined = segment.diff?.start;

    if (segment.start) {
        if (startDiff) {
            startDiff.timestamp = segment.start;
            start = startDiff;
        } else {
            start = {
                timestamp: segment.start,
            };
        }
    }

    if (track?.track_start) {
        if (start) {
            start.latitude = track.track_start[1];
            start.longitude = track.track_start[0];
        } else {
            start = {
                latitude: track.track_start[1],
                longitude: track.track_start[0],
            };
        }
    }

    return start;
}
