import * as React from 'react';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarHeader, CarHeaderProps } from 'widgets/CarHeader/ui/CarHeader/CarHeader';

import { useCar } from 'entities/Car/api/useCar/useCar';

const storybookMeta = createStorybookMeta<CarHeaderProps>({
    title: 'widgets/CarHeader/CarHeader',
    component: CarHeader,

    decorators: [withStorybookRouter()],

    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarHeaderProps & { carId: string }>(({ carId }) => {
    const resource = useCar({
        carId,
        sensors: ['speed', 'mileage', 'fuel_level', 'fuel_distance', 'ext_voltage', 'engine_on', 'gsm_signal_level'],
    });

    return <CarHeader resource={resource} />;
});

export const loading = Template.bind({});
loading.args = {
    carId: '100c7f42-fa23-8c5c-216f-d1faeb1743c5',
};

export const normal = Template.bind({});
normal.args = {
    carId: '000c7f42-fa23-8c5c-216f-d1faeb1743c5',
};
