import * as React from 'react';

import { Header } from 'widgets/Header';

import { CarCardHeaderTabs } from 'features/CarCardHeaderTabs';

import { UseCarResource } from 'entities/Car/api/useCar/useCar';
import { CarHeaderTitle } from 'entities/Car/ui/CarHeaderTitle/CarHeaderTitle';

export interface CarHeaderProps {
    resource: UseCarResource;
}

export const CarHeader: React.FC<CarHeaderProps> = function CarHeader({ resource }) {
    return (
        <React.Suspense
            fallback={
                <Header
                    title={<CarHeaderTitle />}
                    tabs={<CarCardHeaderTabs />}
                    withoutBorder
                />
            }
        >
            <Header
                title={<CarHeaderTitle resource={resource} />}
                tabs={<CarCardHeaderTabs resource={resource} />}
                withoutBorder
            />
        </React.Suspense>
    );
};
