import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Ride date': {
        _meta: {
            status: {
                en: 'APPROVED',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Ride date',
        ru: 'Дата поездки',
        cs: 'Datum jízdy',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
