import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    CarsContentHeader,
    CarsContentHeaderProps,
} from 'widgets/CarsContentHeader/ui/CarsContentHeader/CarsContentHeader';

import { CarsFiltersOptions } from 'components/Cars';

const storybookMeta = createStorybookMeta<CarsContentHeaderProps>({
    title: 'widgets/CarsContentHeader',
    component: CarsContentHeader,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        storybookWidth: '968px',

        filters: {} as CarsFiltersOptions,
    },

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsContentHeaderProps>(CarsContentHeader);

export const normal = Template.bind({});

export const withActiveFilters = Template.bind({});
withActiveFilters.args = { filters: { filters1: 'test' } };

export const full = Template.bind({});
full.args = { filters: { filters1: 'test' }, tagsFilter: 'test' };
full.parameters = { flags: { showCarsGroups: true, car_add: true } };
