import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { withRequestCacheLoader } from 'tests/storybook/loaders/withRequestCacheLoader';

import { CarsFilters, CarsFiltersProps } from 'widgets/CarsFilters/ui/CarsFilters/CarsFilters';

const storybookMeta = createStorybookMeta<CarsFiltersProps>({
    title: 'widgets/CarsFilters',
    component: CarsFilters,

    decorators: [withStorybookRouter()],
    loaders: [withRequestCacheLoader],
});

export default storybookMeta;

const Template = createStorybookTemplate<CarsFiltersProps>(CarsFilters);

export const normal = Template.bind({});
