import * as React from 'react';

import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';
import { minWidthState } from 'tests/storybook/helpers/minWidthState';

import { Header, HeaderProps } from 'widgets/Header/ui/Header/Header';

const storybookMeta = createStorybookMeta<HeaderProps>({
    title: 'widgets/Header',
    component: Header,

    args: {
        storybookWidth: '100vw',
    },

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<HeaderProps>(Header);

const emptyBlock = <span style={{ width: '200px', height: '40px', backgroundColor: 'pink', display: 'block' }} />;

export const normal = Template.bind({});
normal.args = { title: 'Dashboard' };
normal.hermioneFn = minWidthState;

export const empty = Template.bind({});
empty.args = { title: emptyBlock, tabs: emptyBlock };
empty.hermioneFn = minWidthState;
