import * as React from 'react';
import cn from 'classnames/bind';

import { HeaderSearch } from 'features/HeaderSearch';

import styles from 'widgets/Header/ui/Header/Header.css';

export interface HeaderProps {
    className?: string;
    title: React.ReactNode;
    tabs?: React.ReactNode;

    // @todo: temporary props
    withoutBorder?: boolean;
}

const cx = cn.bind(styles);

export const Header: React.FC<HeaderProps> = React.memo(function Header({ className, title, tabs, withoutBorder }) {
    return (
        <header className={cx(styles.header, { withoutBorder }, [className])}>
            {typeof title === 'string' ? (
                <h1 className={cn(styles.left, styles.title)}>{title}</h1>
            ) : (
                <div className={styles.left}>{title}</div>
            )}

            {tabs && <div className={styles.tabs}>{tabs}</div>}

            <HeaderSearch className={styles.right} />
        </header>
    );
});
