import * as React from 'react';
import { useHistory, useLocation } from 'react-router-dom';
import cn from 'classnames';

import { MODAL_OBJECT_TYPE_CGI } from 'constants/constants';

import { SignalAddButton } from 'entities/Signal';

import { ModalObjectTypes } from 'components/types';

import styles from 'widgets/RidesContentHeader/ui/RidesContentHeader/RidesContentHeader.css';

export interface ManageSignalsContentHeaderProps {
    className?: string;
}

export const ManageSignalsContentHeader: React.FC<ManageSignalsContentHeaderProps> =
    function ManageSignalsContentHeader({ className }) {
        let location = useLocation();
        let history = useHistory();

        const onAddClickHandler = React.useCallback(() => {
            const searchParams = new URLSearchParams(location?.search);

            searchParams.set(MODAL_OBJECT_TYPE_CGI, ModalObjectTypes.ADD_SIGNAL);

            history.push(`${location.pathname}?${searchParams}`);
        }, [location]);

        return (
            <div className={cn(styles.ridesContentHeader, className)}>
                <SignalAddButton onClick={onAddClickHandler} />
            </div>
        );
    };
