import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    RidesContentHeader,
    RidesContentHeaderProps,
} from 'widgets/RidesContentHeader/ui/RidesContentHeader/RidesContentHeader';

import { RidesFiltersOptions } from 'components/Rides';

const storybookMeta = createStorybookMeta<RidesContentHeaderProps>({
    title: 'widgets/RidesContentHeader',
    component: RidesContentHeader,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        storybookWidth: '968px',

        filters: {} as RidesFiltersOptions,
    },

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<RidesContentHeaderProps>(RidesContentHeader);

export const normal = Template.bind({});

export const withActiveFilters = Template.bind({});
withActiveFilters.args = { filters: { filters1: 'test' } };
