import { ALL_SIGNALS_UNCHECKED_KEY } from 'constants/constants';

import { SignalDescriptionDictSchema } from 'entities/Signal/types/SignalDescriptionDictSchema';
import { SignalSchema } from 'entities/Signal/types/SignalSchema';

import { fetchRequest } from 'shared/helpers/fetchRequest/fetchRequest';

interface SignalListServerData {
    since?: Nullable<number>;
    until?: Nullable<number>;
    actual_only?: Nullable<boolean>;
    signals?: Nullable<string>;

    page_size?: number;
    cars_cursor?: Nullable<number>;
    sessions_cursor?: Nullable<number>;
}

interface SignalListServerRes {
    can_get_more_pages: boolean;

    next_cars_cursor?: number;
    next_sessions_cursor?: number;

    signals: SignalSchema[];
    signals_descriptions: SignalDescriptionDictSchema;
}

const SIGNALS_PAGE_SIZE_ALL = 5000;
const SIGNALS_TIMEOUT = 20000;

export function fetchAllSignals(filters: SignalListServerData) {
    let payload: SignalListServerData = {
        ...filters,
        page_size: SIGNALS_PAGE_SIZE_ALL,
    };

    if (filters.signals === ALL_SIGNALS_UNCHECKED_KEY) {
        delete payload.signals;
    }

    return fetchRequest<SignalListServerData, SignalListServerRes>('/api/leasing/signals/list', payload, {
        method: 'GET',
        timeout: SIGNALS_TIMEOUT,
    });
}
