import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    SignalsContentHeader,
    SignalsContentHeaderProps,
} from 'widgets/SignalsContentHeader/ui/SignalsContentHeader/SignalsContentHeader';

import { SignalsFiltersOptions } from 'components/Signals';

const storybookMeta = createStorybookMeta<SignalsContentHeaderProps>({
    title: 'widgets/SignalsContentHeader',
    component: SignalsContentHeader,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        storybookWidth: '968px',

        filters: {} as SignalsFiltersOptions,
    },

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<SignalsContentHeaderProps>(SignalsContentHeader);

export const normal = Template.bind({});

export const withActiveFilters = Template.bind({});
withActiveFilters.args = { filters: { filters1: 'test' } };
