import { i18n as i18nBuilder, keyset, MovaLang, plurals } from 'mova-i18n';

const translates = keyset({
    'Signal not found': {
        _meta: {
            status: {
                en: 'REQUIRES_TRANSLATION',
                ru: 'REQUIRES_TRANSLATION',
                cs: 'APPROVED',
            },
        },
        en: 'Signal not found',
        ru: 'Сигнал не найден',
        cs: 'Signál nenalezen',
    },
});

export const i18n = i18nBuilder(process.env.LANG as MovaLang, plurals)(translates);
