import { withStorybookRouter } from 'tests/storybook/decorators/withStorybookRouter';
import { createStorybookMeta } from 'tests/storybook/helpers/createStorybookMeta';
import { createStorybookTemplate } from 'tests/storybook/helpers/createStorybookTemplate';

import {
    UsersContentHeader,
    UsersContentHeaderProps,
} from 'widgets/UsersContentHeader/ui/UsersContentHeader/UsersContentHeader';

const storybookMeta = createStorybookMeta<UsersContentHeaderProps>({
    title: 'widgets/UsersContentHeader',
    component: UsersContentHeader,

    parameters: { backgrounds: { default: 'white' } },

    args: {
        storybookWidth: '968px',
    },

    decorators: [withStorybookRouter()],
});

export default storybookMeta;

const Template = createStorybookTemplate<UsersContentHeaderProps>(UsersContentHeader);

export const normal = Template.bind({});
normal.parameters = { flags: { enableAddUsers: true } };
