import * as React from 'react';
import { useCallback, useState } from 'react';
import cn from 'classnames';

import { enableAddUsersFlag } from 'utils/enableAddUsersFlag';

import { UserCreateModal } from 'features/UserDetails/ui/UserCreateModal/UserCreateModal';

import { UserAddButton } from 'entities/User';

import styles from 'widgets/UsersContentHeader/ui/UsersContentHeader/UsersContentHeader.css';

export interface UsersContentHeaderProps {
    className?: string;
    onUserCreate?: () => void;
}

export const UsersContentHeader: React.FC<UsersContentHeaderProps> = function UsersContentHeader({
    className,
    onUserCreate,
}) {
    const [isUserAddOpened, setUserAddOpened] = useState<boolean>(false);

    const onAddClickHandler = React.useCallback(() => {
        setUserAddOpened(true);
    }, []);

    const onCloseUserAdd = useCallback(() => {
        setUserAddOpened(false);
    }, []);

    return enableAddUsersFlag() ? (
        <div className={cn(styles.usersContentHeader, className)}>
            <UserAddButton onClick={onAddClickHandler} />

            {isUserAddOpened && (
                <UserCreateModal
                    onClose={onCloseUserAdd}
                    onUserCreate={onUserCreate}
                />
            )}
        </div>
    ) : null;
};
