#!/usr/bin/env bash

openssl req -x509 -nodes -new -sha512 \
  -days 3650 -newkey rsa:4096 -keyout VlootkitCA.key \
  -out VlootkitCA.pem -subj "/C=NL/CN=VlootkitCA"

openssl x509 -outform pem -in VlootkitCA.pem -out VlootkitCA.crt

cat > vlootkit.ext <<-EOF
authorityKeyIdentifier=keyid,issuer
basicConstraints=CA:FALSE
keyUsage = digitalSignature, nonRepudiation, keyEncipherment, dataEncipherment
subjectAltName = @alt_names
[alt_names]
# Local hosts
DNS.1 = localhost.vlootkit.com
DNS.2 = localhost.vlootkit.cz
EOF

openssl req -new -nodes -newkey rsa:4096 \
  -keyout localhost.vlootkit.com.key -out localhost.vlootkit.com.csr \
  -subj "/C=NL/L=Amsterdam/O=VlootkitNV/CN=localhost.vlootkit.com"

openssl x509 -req -sha512 -days 365 \
  -extfile vlootkit.ext \
  -CA VlootkitCA.crt -CAkey VlootkitCA.key -CAcreateserial \
  -in localhost.vlootkit.com.csr \
  -out localhost.vlootkit.com.crt

cat localhost.vlootkit.com.crt localhost.vlootkit.com.key > localhost.vlootkit.com.pem

sudo security add-trusted-cert -d -r trustRoot -k "/Library/Keychains/System.keychain" VlootkitCA.pem
