function _isDefaultExport<T extends object>(obj: T | { default: T }): obj is { default: T } {
    return obj.hasOwnProperty('default');
}

export function cjs<T extends object>(obj: T | { default: T }): T {
    return _isDefaultExport(obj) ? obj.default : obj;
}
