const { merge } = require('webpack-merge');

const common = require('./.config/webpack/webpack.common');
const development = require('./.config/webpack/webpack.development');
const production = require('./.config/webpack/webpack.production');
const bundle_analyzer = require('./.config/webpack/webpack.bundleAnalyzer');

const { secrets } = require('./.config/lib/secrets');

module.exports = async ({ mode, type } = { mode: 'production' }) => {
    const commonConfig = common(mode);

    if (mode === 'development') {
        // https://yav.yandex-team.ru/secret/sec-01fs9zscfp4nd2fvan5sjrzh97
        const tokens = await secrets('ver-01g6tpcdr9qmydp7f6tpx22yw8');

        return merge(commonConfig, development({ tokens }));
    } else {
        const productionConfig = merge(commonConfig, production);

        if (type === 'analyze') {
            return merge(productionConfig, bundle_analyzer);
        }

        return productionConfig;
    }
};
