import { IncomingMessage, ServerResponse } from 'node:http';

import { processVuid } from 'controllers/helpers/processVuid';
import { RequestHandlerOptions } from 'types';

import { DM_SECRET } from 'consts/consts';
import { HttpStatusCode } from 'consts/HttpStatusCode';

import { generateCsrfToken } from 'lib/csrf/generateCsrfToken/generateCsrfToken';
import { sendResJson } from 'lib/response/sendResJson/sendResJson';

export async function csrfController(
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<void> {
    const vuid = await processVuid(req, res, { logger });

    return sendResJson(res, HttpStatusCode.OK, {
        code: HttpStatusCode.OK,
        data: {
            csrf: generateCsrfToken(vuid, Date.now(), DM_SECRET),
        },
    });
}
