import { IncomingMessage, ServerResponse } from 'node:http';

import { template } from 'controllers/helpers/template';
import { RequestHandlerOptions } from 'types';

import { HttpStatusCode } from 'consts/HttpStatusCode';

import { getCSP } from 'lib/csp/getCSP';
import { sendResHtml } from 'lib/response/sendResHtml/sendResHtml';
import { setResNoCacheHeaders } from 'lib/response/setResNoCacheHeaders/setResNoCacheHeaders';
import { setResSecurityHeaders } from 'lib/response/setResSecurityHeaders/setResSecurityHeaders';

export async function error404PageController(
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<void> {
    const content = await template('error404');

    const csp = getCSP();

    setResSecurityHeaders(res, csp, false);
    setResNoCacheHeaders(res);

    sendResHtml(res, HttpStatusCode.NOT_FOUND, content);
}
