import { IncomingMessage, ServerResponse } from 'node:http';

import { CognitoUserSession } from 'amazon-cognito-identity-js';
import { processUserSession } from 'controllers/helpers/processUserSession';
import { RequestHandlerOptions } from 'types';

import { HttpStatusCode } from 'consts/HttpStatusCode';

import { sendResJson } from 'lib/response/sendResJson/sendResJson';

export function authCallbacks(
    req: IncomingMessage,
    res: ServerResponse,
    resolve: () => void,
    { logger }: RequestHandlerOptions,
) {
    return {
        onSuccess(session: CognitoUserSession) {
            processUserSession(session, req, res, { logger }).then(resolve, resolve);
        },
        onFailure(error: Error) {
            sendResJson(res, HttpStatusCode.BAD_REQUEST, {
                code: HttpStatusCode.BAD_REQUEST,
                error: {
                    password: error.message,
                },
            });

            return resolve();
        },
        newPasswordRequired() {
            sendResJson(res, HttpStatusCode.BAD_REQUEST, {
                code: HttpStatusCode.BAD_REQUEST,
                error: {
                    challenge: 'NEW_PASSWORD_REQUIRED',
                },
            });

            return resolve();
        },
        customChallenge(data: any) {
            sendResJson(res, HttpStatusCode.BAD_REQUEST, {
                code: HttpStatusCode.BAD_REQUEST,
                error: {
                    challenge: 'CUSTOM_CHALLENGE',
                },
                data,
            });

            return resolve();
        },
        mfaRequired(challenge: string, data: any) {
            sendResJson(res, HttpStatusCode.BAD_REQUEST, {
                code: HttpStatusCode.BAD_REQUEST,
                error: {
                    challenge,
                },
                data,
            });

            return resolve();
        },
        mfaSetup(challenge: string, data: any) {
            sendResJson(res, HttpStatusCode.BAD_REQUEST, {
                code: HttpStatusCode.BAD_REQUEST,
                error: {
                    challenge,
                },
                data,
            });

            return resolve();
        },
        selectMFAType(challenge: string, data: any) {
            sendResJson(res, HttpStatusCode.BAD_REQUEST, {
                code: HttpStatusCode.BAD_REQUEST,
                error: {
                    challenge,
                },
                data,
            });

            return resolve();
        },
        totpRequired(challenge: string, data: any) {
            sendResJson(res, HttpStatusCode.BAD_REQUEST, {
                code: HttpStatusCode.BAD_REQUEST,
                error: {
                    challenge,
                },
                data,
            });

            return resolve();
        },
    };
}
