import { CognitoUserPool } from 'amazon-cognito-identity-js';
import { CognitoJwtVerifier } from 'aws-jwt-verify';

import { DM_AWS_CLIENT_ID, DM_AWS_REGION, DM_AWS_USER_POOL_ID } from 'consts/consts';

export const userPull = new CognitoUserPool({
    UserPoolId: DM_AWS_USER_POOL_ID,
    ClientId: DM_AWS_CLIENT_ID,
    endpoint: `https://cognito-idp.${DM_AWS_REGION}.amazonaws.com`,
});

export const tokenVerifier = CognitoJwtVerifier.create({
    userPoolId: DM_AWS_USER_POOL_ID,
    clientId: DM_AWS_CLIENT_ID,
    tokenUse: 'id',
});
