import { IncomingMessage, ServerResponse } from 'node:http';

import { processVuid } from 'controllers/helpers/processVuid';
import { RequestHandlerOptions } from 'types';

import { DM_SECRET } from 'consts/consts';
import { HttpStatusCode } from 'consts/HttpStatusCode';

import { generateCsrfToken } from 'lib/csrf/generateCsrfToken/generateCsrfToken';
import { validateCsrfToken } from 'lib/csrf/validateCsrfToken/validateCsrfToken';
import { getReqHeaderStr } from 'lib/request/getReqHeaderStr/getReqHeaderStr';
import { sendResJson } from 'lib/response/sendResJson/sendResJson';

export async function processCsrfToken(
    req: IncomingMessage,
    res: ServerResponse,
    { logger }: RequestHandlerOptions,
): Promise<boolean> {
    const vuid = await processVuid(req, res, { logger });
    const csrfHeader = getReqHeaderStr(req, 'x-csrf-token');
    const nextCsrfHeader = generateCsrfToken(vuid, Date.now(), DM_SECRET);

    if (!validateCsrfToken(csrfHeader, vuid, DM_SECRET)) {
        sendResJson(res, HttpStatusCode.BAD_REQUEST, {
            code: HttpStatusCode.BAD_REQUEST,
            error: {
                _: 'Invalid CSRF token',
            },
            data: {
                csrf: nextCsrfHeader,
            },
        });

        return true;
    }

    return false;
}
